/*:
 * @recallectionback 回想イベント終了後に回想一覧に戻るためのプラグイン
 * @author nikutomochi
 *
 * @param 回想一覧に戻るためのスイッチID
 * @desc 回想イベント終了後に回想一覧に戻るためのスイッチID
 * @default 1
 * @type switch
 *
 * @help
 * このプラグインは、回想イベント終了後に回想一覧に戻るための機能を提供します。
 * 回想イベントの最後に、指定したスイッチをONにするイベントコマンドを追加してください。
 */


(function() {
    var parameters = PluginManager.parameters('RecollectionSceneReturn');
    var switchId = Number(parameters['回想一覧に戻るためのスイッチID'] || 252);

    console.log("Switch ID for returning to recollection list: " + switchId);

    var RecollectionBack_Scene_Map_update = function() {
        var _Scene_Map_update = Scene_Map.prototype.update;
        Scene_Map.prototype.update = function() {
            _Scene_Map_update.call(this);
            if ($gameSwitches.value(switchId) && Scene_Recollection._rngd_recollection_doing) {
                console.log("Switch detected and event was played via recollection: " + switchId);
                $gameSwitches.setValue(switchId, false);
                Scene_Recollection.reload_rec_list = true;
                Scene_Recollection._rngd_recollection_doing = false;  // フラグをリセット
                SceneManager.push(Scene_Recollection);
            }
        };
    };

    var RecollectionBack_Scene_Recollection_start = function() {
        var _Scene_Recollection_start = Scene_Recollection.prototype.start;
        Scene_Recollection.prototype.start = function() {
            _Scene_Recollection_start.call(this);
            $gameSwitches.setValue(switchId, false);
            console.log("Recollection started and switch reset: " + switchId);
        };
    };

    if (typeof Scene_Recollection !== 'undefined') {
        RecollectionBack_Scene_Recollection_start();
        RecollectionBack_Scene_Map_update();
    } else {
        var _Scene_Boot_start = Scene_Boot.prototype.start;
        Scene_Boot.prototype.start = function() {
            _Scene_Boot_start.call(this);
            RecollectionBack_Scene_Recollection_start();
            RecollectionBack_Scene_Map_update();
        };
    }
})();